/*
 * Decompiled with CFR 0.152.
 */
package com.goby56.wakes;

import com.goby56.wakes.config.WakesConfig;
import com.goby56.wakes.debug.WakeDebugRenderer;
import com.goby56.wakes.event.PickBoat;
import com.goby56.wakes.event.WakeClientTicker;
import com.goby56.wakes.event.WakeWorldTicker;
import com.goby56.wakes.particle.ModParticles;
import com.goby56.wakes.render.SplashPlaneRenderer;
import com.goby56.wakes.render.WakeRenderer;
import eu.midnightdust.lib.config.MidnightConfig;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.event.client.player.ClientPickBlockGatherCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.irisshaders.iris.api.v0.IrisApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WakesClient
implements ClientModInitializer {
    public static final String MOD_ID = "wakes";
    public static ModMetadata METADATA;
    public static final Logger LOGGER;
    public static boolean areShadersEnabled;

    public void onInitializeClient() {
        FabricLoader.getInstance().getModContainer(MOD_ID).ifPresent(container -> {
            METADATA = container.getMetadata();
        });
        MidnightConfig.init((String)MOD_ID, WakesConfig.class);
        ModParticles.registerParticles();
        ClientTickEvents.START_CLIENT_TICK.register((Object)new WakeClientTicker());
        ClientTickEvents.END_WORLD_TICK.register((Object)new WakeWorldTicker());
        ClientPickBlockGatherCallback.EVENT.register((Object)new PickBoat());
        WorldRenderEvents.AFTER_TRANSLUCENT.register((Object)new WakeRenderer());
        WorldRenderEvents.AFTER_TRANSLUCENT.register((Object)new SplashPlaneRenderer());
        WorldRenderEvents.BEFORE_DEBUG_RENDER.register((Object)new WakeDebugRenderer());
        SplashPlaneRenderer.initSplashPlane();
    }

    public static boolean areShadersEnabled() {
        if (FabricLoader.getInstance().isModLoaded("iris")) {
            return IrisApi.getInstance().getConfig().areShadersEnabled();
        }
        return false;
    }

    static {
        LOGGER = LoggerFactory.getLogger((String)MOD_ID);
        areShadersEnabled = false;
    }
}

